import os
from flask import Flask, render_template, request, redirect
import csv

template_dir = os.path.join(os.path.dirname(__file__), 'templates')
static_dir = os.path.join(os.path.dirname(__file__), 'static')

# Flask est un micro framework open-source de developpement
# web en Python
# creation de l'application web
app = Flask('Conversation', template_folder=template_dir, static_folder = static_dir)


conversation_file_path = os.path.dirname(__file__)+'/conversation.csv'
with open(conversation_file_path, newline='') as csvfile:
    conversationlist = list(csv.reader(csvfile)) # la conversation a afficher


@app.route('/conversation.html')  # le chemin appelant la fonction index()
def conversation():
    """ Retourne la page web venant du patron avec la variable conversation
    """
    return render_template('conversation.html', messages=conversationlist)

def ajout_message(nom_formulaire, droite_gauche):
    message = request.form[nom_formulaire]  # Extrait le message du formulaire
    # Insere le message au debut de la conversation
    conversationlist.append([message, droite_gauche])
    with open(conversation_file_path, 'a', newline='') as csvfile:
        spamwriter = csv.writer(csvfile)
        spamwriter.writerow([message, droite_gauche])
    return redirect('/conversation.html')  # Renvoie la page dynamique

# Associe au chemin message la fonction ci-dessous
@app.route('/message1', methods=['POST'])
def nouveau_message1():
    """ Ajoute un message a la conversation """
    return ajout_message('Message1', "gauche")


@app.route('/message2', methods=['POST'])
def nouveau_message2():
    """ Ajoute un message a la conversation """
    return ajout_message('Message2', "droite")


if __name__ == "__main__":
    app.run(host="0.0.0.0")  # Lance le serveur web
